/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.world.features.ruinednetherportals;

import dev.orderedchaos.projectvibrantjourneys.common.world.features.ruinednetherportals.RuinedPortalDecoratorBase;
import dev.orderedchaos.projectvibrantjourneys.util.LevelUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.NetherFeatures;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.jetbrains.annotations.Nullable;

public class WarpedForestRuinedPortalDecorator
extends RuinedPortalDecoratorBase {
    public WarpedForestRuinedPortalDecorator() {
        super("warped_forest_ruined_portal_decorator");
    }

    @Override
    @Nullable
    public BlockState getTopSoil(WorldGenLevel level, RandomSource random) {
        float chance = random.m_188501_();
        if (chance <= 0.75f) {
            return Blocks.f_50690_.m_49966_();
        }
        return null;
    }

    @Override
    @Nullable
    public BlockState getFillerSoil(WorldGenLevel level, RandomSource random) {
        float oreChance = random.m_188501_();
        if (oreChance <= 0.03f) {
            return Blocks.f_50331_.m_49966_();
        }
        if (oreChance <= 0.05f) {
            return Blocks.f_49998_.m_49966_();
        }
        return null;
    }

    @Override
    public void decorate(WorldGenLevel level, ChunkGenerator generator, RandomSource random, BlockPos groundPos) {
        BlockPos pos = groundPos.m_7494_();
        if (LevelUtils.isEmptyOrReplaceable((ServerLevelAccessor)level, pos)) {
            float chance = random.m_188501_();
            if (chance < 0.02f) {
                Optional bigMushroom = level.m_9598_().m_175515_(Registries.f_256911_).m_203636_(TreeFeatures.f_195119_);
                bigMushroom.ifPresent(feature -> ((ConfiguredFeature)feature.m_203334_()).m_224953_(level, generator, random, pos));
            } else if (chance < 0.15f) {
                Optional warpedForestVegetation = level.m_9598_().m_175515_(Registries.f_256911_).m_203636_(NetherFeatures.f_195039_);
                warpedForestVegetation.ifPresent(feature -> ((ConfiguredFeature)feature.m_203334_()).m_224953_(level, generator, random, pos));
            } else if (chance < 0.16f) {
                Optional twistingVines = level.m_9598_().m_175515_(Registries.f_256911_).m_203636_(NetherFeatures.f_195044_);
                twistingVines.ifPresent(feature -> ((ConfiguredFeature)feature.m_203334_()).m_224953_(level, generator, random, pos));
            }
        }
    }
}

